
#version 430 core

layout(location = 0) out vec4 luminescence;

in vec2 TexCoords;

uniform sampler2D Bloom;

uniform bool horizontal;
  
uniform float weight[5] = float[] (0.227027, 0.1945946, 0.1216216, 0.054054, 0.016216);

void main()
{             
	

	 vec2 bloom_tex_offset = 1.0 / textureSize(Bloom, 0); // gets size of single texel

	 float lightStrength = texture(Bloom, TexCoords).a;
	 float bloomMultiplier = lightStrength;


     vec3 bloomResult = texture(Bloom, TexCoords).rgb * weight[0] * bloomMultiplier;


     if(horizontal)
     {
         for(int i = 1; i < 5; ++i)
         {
            bloomResult += (texture(Bloom, TexCoords + vec2(bloom_tex_offset.x * i, 0.0)).rgb * weight[i])* bloomMultiplier;
            bloomResult += (texture(Bloom, TexCoords - vec2(bloom_tex_offset.x * i, 0.0)).rgb * weight[i])* bloomMultiplier;

         }
     }
     else
     {
         for(int i = 1; i < 5; ++i)
         {
             bloomResult += (texture(Bloom, TexCoords + vec2(0.0, bloom_tex_offset.y * i)).rgb * weight[i])* bloomMultiplier;
             bloomResult += (texture(Bloom, TexCoords - vec2(0.0, bloom_tex_offset.y * i)).rgb * weight[i])* bloomMultiplier;

         }
     }

     luminescence.xyz = bloomResult;
	 luminescence.w = lightStrength;
}

